package gov.va.vinci.dart.dms.db.mock;

import java.util.HashMap;

import gov.va.vinci.dart.dms.biz.Attribute;
import gov.va.vinci.dart.dms.db.AttributeDAO;

public class AttributeDAOMock implements AttributeDAO {

	private static HashMap<Integer,Attribute> IDHash = new HashMap<Integer,Attribute>();
	private static boolean initialized = false;
	private static int idCounter = 1;

	@Override
	public void save(Attribute attribute) {
		if (attribute == null) {
			throw new IllegalArgumentException();
		}
		
		initializeAttributeHash();
		
		if (attribute.getId() == 0) {
			attribute.setId(idCounter++);
		}
		
		IDHash.put(attribute.getId(), attribute);
	}

	@Override
	public void delete(Attribute attribute) {
		if (attribute == null) {
			throw new IllegalArgumentException();
		}

		initializeAttributeHash();

		IDHash.remove(attribute.getId());
	}

	@Override
	public Attribute findById(int attributeId) {
		initializeAttributeHash();

		return IDHash.get(attributeId);
	}

	public void initializeAttributeHash() {
		if (initialized == true) {
			return;
		}
		initialized = true;
	}
}
